/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;
import net.puffish.skillsmod.experience.calculation.condition.FallbackCondition;

public interface Condition<T>
extends Predicate<T> {
    default public <R> Condition<R> map(Function<R, T> function) {
        return r -> this.test(function.apply(r));
    }

    public static <T> Result<Condition<T>, Failure> parse(JsonElementWrapper rootElement, Map<String, ConditionFactory<T>> factories, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> Condition.parse(rootObject, factories, context));
    }

    public static <T> Result<Condition<T>, Failure> parse(JsonObjectWrapper rootObject, Map<String, ConditionFactory<T>> factories, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional<String> optType = rootObject.getString("type").ifFailure(failures::add).getSuccess();
        Result<JsonElementWrapper, Failure> maybeDataElement = rootObject.get("data");
        Optional optFallback = rootObject.get("fallback").getSuccess().flatMap(fallbackElement -> fallbackElement.getAsBoolean().ifFailure(failures::add).getSuccess());
        if (failures.isEmpty()) {
            return Condition.build(optType.orElseThrow(), maybeDataElement, rootObject.getPath().thenObject("type"), factories, context).orElse(failure -> {
                if (optFallback.isPresent()) {
                    context.addWarning((Failure)failure);
                    return Result.success(new FallbackCondition((Boolean)optFallback.orElseThrow()));
                }
                return Result.failure(failure);
            });
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    private static <T> Result<Condition<T>, Failure> build(String type, Result<JsonElementWrapper, Failure> maybeDataElement, JsonPath typePath, Map<String, ConditionFactory<T>> factories, ConfigContext context) {
        ConditionFactory<Result<JsonElementWrapper, Failure>> factory = factories.get(type);
        if (factory == null) {
            return Result.failure(typePath.failureAt("Expected a valid condition type"));
        }
        return ((Result)factory.apply(maybeDataElement, context)).mapSuccess(c -> c);
    }
}

